@extends('frontend.include.app')
<style>
    .error {
        color: red !important;
    }
    .alert-danger {
        color: #721c24;
        background-color: #f8d7da;
        border-color: #f5c6cb;
        padding: 0.75rem 1.25rem;
        margin-bottom: 1rem;
        border: 1px solid transparent;
        border-radius: 0.25rem;
    }
    .alert-danger ul {
        margin: 0;
        padding-left: 20px;
    }
    .is-invalid {
        border-color: #dc3545 !important;
    }
    .invalid-feedback {
        display: none;
        color: #dc3545;
        font-size: 0.875em;
        margin-top: 0.25rem;
    }
    .is-invalid ~ .invalid-feedback {
        display: block;
    }
    .toggle-password {
        position: absolute;
        top: 50%;
        right: 15px;
        transform: translateY(-50%);
        cursor: pointer;
        color: #999;
        z-index: 10;
    }
    .inner-login-page .inner-main-input label {
        text-transform: none !important;
    }
    .profile_title_input .inner-main-input.title_inpt {
        max-width: 11.1rem !important;
    }
    .profile_title_input .inner-main-input.title_inpt select {
        width: 11rem !important;
        margin: 0;
    }
</style>

<section>
    <div class="inner-login vendor">
        <div class="row">
            <div class="col-lg-6">
                <div class="inner-login-img">
                    <figure>
                        <img src="{{ asset('frontend/images/signup.png') }}" alt="">
                    </figure>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="upper-high-main">
                    <div class="inner-login-input-form register-main-wrapper">
                        <div class="inner-login-page">
                            <div class="inner-login-wrapper">
                                <div class="logo-login register-logo">
                                    <img src="{{ asset('frontend/images/login-logo.png') }}" alt="">
                                </div>
                                <h2>Registration</h2>
                                <p>Welcome to Dachboxit. If you are interested in becoming one of our Service Points, please fill out the form below and send it to us. We will then get in touch with you.</p>
                            </div>
                            @if($errors->any())
                                <div class="alert alert-danger">
                                    <ul>
                                        @foreach($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif

                            <form id="registerForm" method="POST" action="{{ route('vendor.register') }}" class="email-login">
                                @csrf
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="new_in_business" id="new_in_business" {{ old('new_in_business') ? 'checked' : '' }}>
                                    <label class="form-check-label" for="new_in_business">Are you new in business</label>
                                </div>
                                <div class="row">
                                    <div class="col-md-3 inner-main-input">
                                        <label for="title" class="form-label">Title*</label>
                                        <select class="form-select @error('title') is-invalid @enderror" name="title" required>
                                            <option value="">Select Title</option>
                                            <option value="Mr" {{ old('title') == 'Mr' ? 'selected' : '' }}>Mr</option>
                                            <option value="Ms" {{ old('title') == 'Ms' ? 'selected' : '' }}>Ms</option>
                                            <option value="Mrs" {{ old('title') == 'Mrs' ? 'selected' : '' }}>Mrs</option>
                                        </select>
                                        @error('title')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                    </div>
                                    
                                    <div class="col-md-4 inner-main-input">
                                        <label for="first_name" class="form-label">First Name*</label>
                                        <input type="text" class="form-control @error('first_name') is-invalid @enderror" name="first_name" value="{{ old('first_name') }}" placeholder="Enter first name" required>
                                        @error('first_name')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                    </div>
                                    
                                    <div class="col-md-4 inner-main-input">
                                        <label for="last_name" class="form-label">Surname*</label>
                                        <input type="text" class="form-control @error('last_name') is-invalid @enderror" name="last_name" value="{{ old('last_name') }}" placeholder="Enter surname" required>
                                        @error('last_name')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                    </div>
                                    
                                    <div class="col-md-12 inner-main-input">
                                        <label for="street" class="form-label">Street, House Number*</label>
                                        <input type="text" class="form-control @error('street') is-invalid @enderror" name="street" value="{{ old('street') }}" placeholder="Enter your street, house number" required>
                                        @error('street')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                    </div>
                                    
                                    <div class="col-md-6 inner-main-input">
                                        <label for="zip_code" class="form-label">Zip Code*</label>
                                        <input type="text" class="form-control @error('zip_code') is-invalid @enderror" name="zip_code" value="{{ old('zip_code') }}" placeholder="Enter zip code" required>
                                        @error('zip_code')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                    </div>
                                    
                                    <div class="col-md-6 inner-main-input">
                                        <label for="city" class="form-label">City*</label>
                                        <input type="text" class="form-control @error('city') is-invalid @enderror" name="city" value="{{ old('city') }}" placeholder="Enter city" required>
                                        @error('city')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                    </div>
                                    
                                    <div class="col-md-12 inner-main-input">
                                        <label for="region" class="form-label">Region/State*</label>
                                        <select id="region" class="form-select @error('region') is-invalid @enderror" name="region" required>
                                            <option value="">Select..</option>
                                            <option value="Baden-Württemberg" {{ old('region', $user->region ?? '') == 'Baden-Württemberg' ? 'selected' : '' }}>Baden-Württemberg</option>
                                            <option value="Bavaria" {{ old('region', $user->region ?? '') == 'Bavaria' ? 'selected' : '' }}>Bavaria</option>
                                            <option value="Berlin" {{ old('region', $user->region ?? '') == 'Berlin' ? 'selected' : '' }}>Berlin</option>
                                            <option value="Brandenburg" {{ old('region', $user->region ?? '') == 'Brandenburg' ? 'selected' : '' }}>Brandenburg</option>
                                            <option value="Bremen" {{ old('region', $user->region ?? '') == 'Bremen' ? 'selected' : '' }}>Bremen</option>
                                            <option value="Hamburg" {{ old('region', $user->region ?? '') == 'Hamburg' ? 'selected' : '' }}>Hamburg</option>
                                            <option value="Hesse" {{ old('region', $user->region ?? '') == 'Hesse' ? 'selected' : '' }}>Hesse</option>
                                            <option value="Lower Saxony" {{ old('region', $user->region ?? '') == 'Lower Saxony' ? 'selected' : '' }}>Lower Saxony</option>
                                            <option value="Mecklenburg-Vorpommern" {{ old('region', $user->region ?? '') == 'Mecklenburg-Vorpommern' ? 'selected' : '' }}>Mecklenburg-Vorpommern</option>
                                            <option value="North Rhine-Westphalia" {{ old('region', $user->region ?? '') == 'North Rhine-Westphalia' ? 'selected' : '' }}>North Rhine-Westphalia</option>
                                            <option value="Rhineland-Palatinate" {{ old('region', $user->region ?? '') == 'Rhineland-Palatinate' ? 'selected' : '' }}>Rhineland-Palatinate</option>
                                            <option value="Saarland" {{ old('region', $user->region ?? '') == 'Saarland' ? 'selected' : '' }}>Saarland</option>
                                            <option value="Saxony" {{ old('region', $user->region ?? '') == 'Saxony' ? 'selected' : '' }}>Saxony</option>
                                            <option value="Saxony-Anhalt" {{ old('region', $user->region ?? '') == 'Saxony-Anhalt' ? 'selected' : '' }}>Saxony-Anhalt</option>
                                            <option value="Schleswig-Holstein" {{ old('region', $user->region ?? '') == 'Schleswig-Holstein' ? 'selected' : '' }}>Schleswig-Holstein</option>
                                            <option value="Thuringia" {{ old('region', $user->region ?? '') == 'Thuringia' ? 'selected' : '' }}>Thuringia</option>
                                        </select>
                                        @error('region')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-md-12 inner-main-input">
                                        <label for="email" class="form-label">Email*</label>
                                        <input type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" placeholder="Enter email address" required>
                                        @error('email')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                    </div>
                                    
                                    <div class="col-md-12 inner-main-input">
                                        <div class="d-flex profile_title_input">
                                            <div class="inner-main-input inner-main-input2 title_inpt">
                                                <label class="form-label">Phone Code*</label>
                                                <select class="form-select country_code_custom @error('phone_code') is-invalid @enderror" name="phone_code" required id="phone_code">
                                                    <option data-image="https://flagcdn.com/16x12/de.png"  value="+49" {{ old('phone_code') == '+49' ? 'selected' : '' }}>+49</option>
                                                    <option value="+43" data-image="https://flagcdn.com/16x12/at.png"  {{ old('phone_code') == '+43' ? 'selected' : '' }}> +43</option>
                                                    <option value="+41" data-image="https://flagcdn.com/16x12/ch.png"  {{ old('phone_code') == '+41' ? 'selected' : '' }}>+41</option>
                                                </select>
                                                @error('phone_code')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                            </div>
                                            <div class="inner-main-input inner-main-input2">
                                                <label class="form-label">Phone Number*</label>
                                                <input type="tel" name="phone_number" class="form-control @error('phone_number') is-invalid @enderror" value="{{ old('phone_number') }}" placeholder="Phone Number" required>
                                                @error('phone_number')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                            </div>
                                        </div>
                                    </div>
                                   
                                    <div class="col-md-6 inner-main-input">
                                        <label for="business_model" class="form-label">Business Model*</label>
                                        <select name="business_model" class="form-select @error('business_model') is-invalid @enderror" required>
                                            <option value="">Select Business Model</option>
                                            <option value="Fulltimer" {{ old('business_model') == 'Fulltimer' ? 'selected' : '' }}>Fulltimer</option>
                                            <option value="Side Business" {{ old('business_model') == 'Side Business' ? 'selected' : '' }}>Side Business</option>
                                        </select>
                                        @error('business_model')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                    </div>
                                    
                                    <div class="col-md-6 inner-main-input">
                                        <label for="size_of_location" class="form-label">Size Of Location*</label>
                                        <select name="size_of_location" class="form-select @error('size_of_location') is-invalid @enderror" required>
                                            <option value="">Select Size</option>
                                            <option value="Beginner" {{ old('size_of_location') == 'Beginner' ? 'selected' : '' }}>Beginner</option>
                                            <option value="Small (> 5)" {{ old('size_of_location') == 'Small (> 5)' ? 'selected' : '' }}>Small (&gt; 5 Employees)</option>
                                            <option value="Middle (6 - 15)" {{ old('size_of_location') == 'Middle (6 - 15)' ? 'selected' : '' }}>Middle (6 - 15 Employees)</option>
                                            <option value="Large (16-35)" {{ old('size_of_location') == 'Large (16-35)' ? 'selected' : '' }}>Large (16-35 Employees)</option>
                                            <option value="XXL (>30)" {{ old('size_of_location') == 'XXL (>30)' ? 'selected' : '' }}>XXL (&gt;30 Employees)</option>
                                        </select>
                                        @error('size_of_location')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                    </div>
                                    
                                </div>

                                <button type="submit" class="btn primary-btn w-100">Register</button>
                                <p class="not-yet">Already have an account? <a href="{{ route('vendor.login') }}">Log In</a></p>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@if(session('success'))
<div class="modal fade" id="registrationSuccessModal" tabindex="-1" aria-labelledby="successModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="successModalLabel">Registration Submitted</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body text-success">
                {{ session('success') }}
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" data-bs-dismiss="modal">OK</button>
            </div>
        </div>
    </div>
</div>
@endif
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.5/jquery.validate.min.js"></script>
<script>
    function formatFlag(option) {
        if (!option.id) return option.text;
        const imageUrl = $(option.element).data('image');
        const text = option.text;
        if (imageUrl) {
            return $(`<span><img src="${imageUrl}" style="width:16px; height:auto; margin-right:8px;"> ${text}</span>`);
        }
        return text;
    }

    $(document).ready(function () {
        $('#phone_code').select2({
            templateResult: formatFlag,
            templateSelection: formatFlag,
            minimumResultsForSearch: -1 
        });
    });
</script>
<script>
    $(document).ready(function() {
        

        $.validator.addMethod("numericOnly", function(value, element) {
            return this.optional(element) || /^[0-9]+$/.test(value);
        }, "Please enter valid phone number.");

        $("#registerForm").validate({
            rules: {
                title: { required: true },
                first_name: { required: true, minlength: 2, maxlength: 50 },
                last_name: { required: true, minlength: 2, maxlength: 50 },
                email: {
                    required: true,
                    email: true,
                    remote: {
                        url: "{{ route('vendor.check.email') }}",
                        type: "GET",
                        data: {
                            email: function() {
                                return $("input[name='email']").val();
                            }
                        },
                        dataFilter: function(response) {
                            return response === 'false';
                        }
                    }
                },
                phone_code: { required: true },
                phone_number: {
                    required: true,
                    numericOnly: true,
                    minlength: 8,
                    maxlength: 15
                },
                street: { required: true },
                zip_code: { required: true },
                city: { required: true },
                region: { required: true },
                business_model: { required: true },
                size_of_location: { required: true }
            },
            messages: {
                title: "Please select a title.",
                first_name: {
                    required: "Please enter your first name.",
                    minlength: "First name must be at least 2 characters.",
                    maxlength: "First name must be less than 50 characters."
                },
                last_name: {
                    required: "Please enter your surname.",
                    minlength: "Surname must be at least 2 characters.",
                    maxlength: "Surname must be less than 50 characters."
                },
                email: {
                    required: "Please enter email address.",
                    email: "Please enter valid email address.",
                    remote: "This email is already taken."
                },
                phone_code: "Please select phone code.",
                phone_number: {
                    required: "Please enter your phone number.",
                    numericOnly: "Please enter valid phone number.",
                    minlength: "Phone number should be between 8 to 15 digits.",
                    maxlength: "Phone number should be between 8 to 15 digits."
                },
                street: "Please enter your street and house number.",
                zip_code: "Please enter your zip code.",
                city: "Please enter your city.",
                region: "Please enter your region or state.",
                business_model: "Please select business model.",
                size_of_location: "Please select size of location."
            },
            errorElement: "div",
            errorClass: "invalid-feedback",
            highlight: function(element) {
                $(element).addClass('is-invalid').removeClass('is-valid');
            },
            unhighlight: function(element) {
                $(element).removeClass('is-invalid').addClass('is-valid');
            },
            errorPlacement: function(error, element) {
                error.insertAfter(element);
            }
        });
    });

   
</script>

@if(session('success'))
<script>
    document.addEventListener('DOMContentLoaded', function() {
        var myModal = new bootstrap.Modal(document.getElementById('registrationSuccessModal'));
        myModal.show();
    });
</script>
@endif